import base64
from itertools import groupby

from staff.headcounts.permissions import Permissions
from staff.lib.decorators import front_dumps
from staff.lib import waffle
from staff.person.models import Staff

from staff.navigation.models import Navigation


NAVIGATION_FIELDS = [
    'application_id',
    'name',
    'name_en',
    'title',
    'title_en',
    'url',
    'url_en',
    'icon',

    'is_main',
]


def decode_icon(icon_str):
    return base64.b64decode(icon_str)


def encode_icon(icon_binary):
    return base64.b64encode(icon_binary)


def get_navigations_dict():
    query = (
        Navigation.objects
        .filter(is_active=True)
        .order_by('-is_main', 'position')
        .values(*NAVIGATION_FIELDS)
    )

    data = {'main': [], 'secondary': []}

    for is_main, navigations in groupby(query, key=lambda x: x['is_main']):
        group = 'main' if is_main else 'secondary'
        for n in navigations:
            del n['is_main']
            data[group].append(n)

    return data


def get_navigations():
    data = get_navigations_dict()
    return serialize(data)


def serialize(data):
    return front_dumps(data)


def is_management_options_available(person: Staff) -> bool:
    if not waffle.switch_is_active('enable_management_options_navigation'):
        return False

    return Permissions(person).has_management_options()
