from django.forms import ModelForm, FileField
from django.core.urlresolvers import reverse

from .models import Navigation
from .controller import encode_icon


class NavigationLink(object):
    def __init__(self, instance):
        self.url = reverse('navigation:get_icon', args=[instance.id])
        self.data = instance.icon

    def __str__(self):
        return self.url


class NavigationEditForm(ModelForm):
    icon = FileField(required=False, label='Иконка')

    def __init__(self, *args, **kwargs):
        instance = kwargs.get('instance')
        if instance and instance.icon:
            kwargs['initial'] = {'icon': NavigationLink(instance=instance)}

        super(NavigationEditForm, self).__init__(*args, **kwargs)

    def clean_icon(self):
        icon = self.cleaned_data['icon']
        if not icon:
            return None
        elif isinstance(icon, NavigationLink):
            return icon.data
        else:
            return encode_icon(icon.read())

    class Meta:
        model = Navigation
        fields = '__all__'
