# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Navigation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('description', models.TextField(verbose_name='Описание', blank=True)),
                ('is_active', models.BooleanField(default=True)),
                ('position', models.PositiveIntegerField(verbose_name='Порядковый номер')),
                ('application_id', models.CharField(verbose_name='Идентификатор', max_length=32, unique=True)),
                ('url', models.URLField(verbose_name='Ссылка на сервис')),
                ('url_en', models.URLField(verbose_name='Ссылка на англ. сервис', blank=True, default='')),
                ('icon', models.TextField(blank=True, null=True)),
                ('name', models.CharField(verbose_name='Название', max_length=16)),
                ('name_en', models.CharField(verbose_name='Англ. название', max_length=16)),
                ('title', models.CharField(max_length=16, blank=True)),
                ('title_en', models.CharField(max_length=16, blank=True)),
                ('is_main', models.BooleanField(verbose_name='Основной сервис', default=False)),
                ('last_modifier', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Staff')),
            ],
        ),
    ]
