from django.db import models


class Navigation(models.Model):
    created_at = models.DateTimeField(auto_now_add=True)
    modified_at = models.DateTimeField(auto_now=True)
    last_modifier = models.ForeignKey(
        'django_intranet_stuff.Staff', null=True, blank=True
    )
    description = models.TextField(blank=True, verbose_name='Описание')
    is_active = models.BooleanField(default=True)
    position = models.PositiveIntegerField(verbose_name='Порядковый номер')
    application_id = models.CharField(
        max_length=32, verbose_name='Идентификатор', unique=True
    )
    url = models.URLField(verbose_name='Ссылка на сервис')
    url_en = models.URLField(blank=True, default='', verbose_name='Ссылка на англ. сервис')
    icon = models.TextField(blank=True, null=True)
    name = models.CharField(max_length=16, verbose_name='Название')
    name_en = models.CharField(max_length=16, verbose_name='Англ. название')

    title = models.CharField(max_length=16, blank=True)
    title_en = models.CharField(max_length=16, blank=True)

    is_main = models.BooleanField(
        default=False, verbose_name='Основной сервис'
    )

    def __str__(self):
        return "%s (%s)" % (self.name_en, self.title_en)
