from django.http import HttpResponse, Http404, HttpResponseServerError
from django.views.decorators.http import require_GET

from staff.lib.decorators import responding_json, available_for_external

from staff.navigation.controller import get_navigations, decode_icon, is_management_options_available
from staff.navigation.models import Navigation


def get_icon(request, nav_id):
    try:
        navigation = Navigation.objects.get(pk=nav_id)
    except Navigation.DoesNotExist:
        return Http404('Wrong navigation id provided')

    try:
        decoded = decode_icon(navigation.icon)
    except Exception:
        raise HttpResponseServerError

    response = HttpResponse(decoded)
    response['Content-Disposition'] = (
        'attachment; filename="%s.svg"' % navigation.application_id
    )
    response['Content-Type'] = 'image/svg+xml'
    response['Content-Length'] = len(decoded)
    return response


def navigation_list(request):
    navigations = get_navigations()
    return HttpResponse(
        navigations,
        content_type='application/json; charset=utf-8'
    )


@available_for_external
@require_GET
@responding_json
def navigation_options(request):
    return {'management_options_available': is_management_options_available(request.user.get_profile())}
