from staff.lib.utils.ordered_choices import OrderedChoices


OEBS_RESOURCE_NAME = OrderedChoices(
    ('BONUS', 'getBonus'),
    ('REWARD', 'getReward'),
    ('PAYSYS', 'getPaySys'),
    ('REVIEW', 'getReview'),
    ('MANAGEMENT_ORG', 'managementOrg'),
    ('MANAGEMENT_ORG_HIER', 'ManagementOrgHier'),
    ('OFFICE', 'office'),
    ('PERSON', 'person'),
    ('LEAVE_BALANCE', 'leaveBalance'),
    ('HEADCOUNT', 'getDetailLimit'),
    ('OCCUPATION', 'scales'),
    ('JOB', 'getJobs'),
    ('GEOGRAPHY', 'geography'),
    ('HR_PRODUCT', 'HRProducts'),
    ('BUSINESS_CENTER', 'getBusinessCentres'),
    ('TAX_UNIT', 'getTaxUnit'),
    ('GRADE_HIST', 'gradeHist'),
    ('CURRENCY', 'currency'),
)
"""
represents last part of resource path in OEBS
e.g for OCCUPATION full path will be https://wto-test.oebs.yandex-team.ru/rest/scales
so for OCCUPATION value will be 'scales'
"""


REQUEST_METHOD = OrderedChoices(
    'GET',
    'POST',
)


PERSON_TYPE = OrderedChoices(
    ('EMPLOYEE', 'Сотрудник'),
    ('HOMEWORKER', 'Надомник'),
    ('EXTERNAL', 'Внешний консультант'),  # ?
    ('DIRECTOR', 'Член совета директоров'),  # ?
)


ACTIVE_STATUS = OrderedChoices(
    ('Закрыта', 0, 'Закрыта'),
    ('Закрыто', 0, 'Закрыто'),
    ('Открыта', 1, 'Открыта'),
    ('Открыто', 1, 'Открыто'),
)


POSITION_TYPE = OrderedChoices(
    'OCCUPIED_NEW',
    'OCCUPIED_REPLACEMENT',
    'OFFER_NEW',
    'OFFER_REPLACEMENT',
    'VACANCY_OPEN_NEW',
    'VACANCY_OPEN_REPLACEMENT',
    'VACANCY_PLAN_NEW',
    'VACANCY_PLAN_REPLACEMENT',
    'RESERVE_NEW',
    'MATERNITY_NEW',
    'MATERNITY_REPLACEMENT',
)


PERSON_POSITION_STATUS = OrderedChoices(
    'OCCUPIED',
    'OFFER',
    'VACANCY_OPEN',
    'VACANCY_PLAN',
    'RESERVE',
    'MATERNITY',
)

REPLACEMENT_TYPE = OrderedChoices(
    'HAS_REPLACEMENT',
    'HC_IS_BUSY',
    'HAS_REPLACEMENT_AND_HC_IS_BUSY',
    'WO_REPLACEMENT',
)
