import json
from typing import Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class BonusDatasource(JsonDatasource):
    @classmethod
    def _bonus_data(cls, oebs_bonus_dict: Dict) -> Dict:
        scheme_data = []
        bonuses = oebs_bonus_dict.get('bonus')

        if bonuses is not None:
            for bonus in bonuses:
                scheme_data.append(
                    {
                        'bonus_id': bonus['bonusID'],
                        'value_type': bonus['valueType'],
                        'value_source': bonus['valueSource'],
                        'value': bonus['value'],
                    },
                )
        else:   # TODO: remove
            scheme_data.append(
                {
                    'bonus_id': -1,
                    'value_type': oebs_bonus_dict['valueType'],
                    'value_source': oebs_bonus_dict['valueSource'],
                    'value': oebs_bonus_dict['value'],
                },
            )

        return {
            'name': oebs_bonus_dict['schemeName'],
            'description': oebs_bonus_dict['description'],
            'start_date': cls.get_date(oebs_bonus_dict['startDate']),
            'end_date': cls.get_date(oebs_bonus_dict['endDate']),
            'scheme_id': oebs_bonus_dict['schemeID'],
            'schemes_line_id': oebs_bonus_dict['schemesLineID'],
            'category': oebs_bonus_dict.get('accCategory'),
            'value_type': oebs_bonus_dict.get('valueType'),
            'value_source': oebs_bonus_dict.get('valueSource'),
            'value': oebs_bonus_dict.get('value'),
            'scheme_data': json.dumps(scheme_data),
        }

    def get_iter(self, data):
        for item in data['bonusSchemes']:
            yield self._bonus_data(item)
