from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class BusinessCenterDatasource(JsonDatasource):
    @classmethod
    def _oebs_data(cls, data: dict) -> dict:
        return {
            'code': str(data['code']),
            'name_ru': data['businessCentreNameRus'] or '',
            'name_en': data['businessCentreNameEng'] or '',
            'start_date': cls.get_date(data['startDate']),
            'end_date': cls.get_date(data['endDate']),
            'staff_usage': data['staffUsage'],
        }

    def get_iter(self, data):
        for item in data['BusinessCentres']:
            yield self._oebs_data(item)
