from typing import Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class CurrencyDatasource(JsonDatasource):
    @classmethod
    def _currency_data(cls, oebs_currency_dict: Dict[str, str]) -> Dict[str, str]:
        return {
            'code': oebs_currency_dict['currency_Name'],
        }

    def get_iter(self, data):
        for item in data['currency']:
            yield self._currency_data(item)
