from typing import Any, Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class GeographyDatasource(JsonDatasource):
    @classmethod
    def _geography_data(cls, oebs_geography_dict: Dict[str, Any]) -> Dict[str, Any]:
        return {
            'code': oebs_geography_dict['code'],
            'description': oebs_geography_dict['description'],
            'start_date': cls.get_date(oebs_geography_dict['startDate']),
            'end_date': cls.get_date(oebs_geography_dict['endDate']),
        }

    def get_iter(self, data):
        for item in data['geography']:
            yield self._geography_data(item)
