from typing import Dict, Any

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class HRProductDatasource(JsonDatasource):
    root_field = 'products'
    identity_field = 'productID'

    @classmethod
    def get_item(cls, oebs_products_dict: dict) -> Dict[str, Any]:
        return {
            'product_id': oebs_products_dict['productID'],
            'product_name': oebs_products_dict['productName'],
            'end_date': cls.get_date(oebs_products_dict['endDate']),
            'service_code': oebs_products_dict['serviceCode'],
            'service_name': oebs_products_dict['serviceName'],
            'service_abc': oebs_products_dict['serviceABC'],
        }

    def is_preferred(self, new_candidate: Dict[str, Any], current_candidate: Dict[str, Any]) -> bool:
        if new_candidate['end_date'] is None:
            return True

        if current_candidate['end_date'] is None:
            return False

        return new_candidate['end_date'] > current_candidate['end_date']
