from typing import Any, Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class JobsDatasource(JsonDatasource):
    @classmethod
    def _jobs_data(cls, oebs_jobs_dict: Dict[str, Any]) -> Dict[str, Any]:
        return {
            'code': oebs_jobs_dict['code'],
            'start_date': cls.get_date(oebs_jobs_dict['startDate']),
            'end_date': cls.get_date(oebs_jobs_dict['endDate']),
            'name': oebs_jobs_dict['jobNameRus'],
            'name_en': oebs_jobs_dict['jobNameEng'],
            'is_deleted_from_oebs': False,
        }

    def get_iter(self, data):
        for item in data['jobs']:
            yield self._jobs_data(item)
