import datetime
import json
from dateutil import parser
from typing import Any, Dict, Optional

from staff.oebs.controllers.datasources.oebs_datasource import OEBSDatasource
from staff.oebs.exceptions import OEBSResponseError


class JsonDatasource(OEBSDatasource):
    root_field: Optional[str] = None
    identity_field: Optional[str] = None

    def _deserialize_data(self, data):
        try:
            result = json.loads(data)
        except ValueError:
            raise OEBSResponseError(data.decode('utf-8'))
        return result

    @classmethod
    def get_date(cls, value: str) -> Optional[datetime.date]:
        parsed_value = cls.get_datetime(value)

        return parsed_value and parsed_value.date()

    @staticmethod
    def get_datetime(value: str) -> Optional[datetime.datetime]:
        if not value:
            return None

        return parser.parse(value)

    def get_iter(self, data: Dict):
        if self.root_field is not None:
            data = data[self.root_field]

        candidates = {}

        if self.identity_field is None:
            for item in data:
                yield self.get_item(item)
            return

        for item_candidate in data:
            candidate_id = item_candidate[self.identity_field]
            candidate_data = self.get_item(item_candidate)

            if candidate_id not in candidates or self.is_preferred(candidate_data, candidates[candidate_id]):
                candidates[candidate_id] = candidate_data

        yield from candidates.values()

    def get_item(self, item_data: Dict[str, Any]) -> Dict[str, Any]:
        return item_data

    def is_preferred(self, new_candidate: Dict[str, Any], current_candidate: Dict[str, Any]) -> bool:
        return True
