from typing import Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class OccupationDatasource(JsonDatasource):
    @classmethod
    def _occupation_data(cls, oebs_scale_dict: Dict) -> Dict:
        return {
            'end_date': cls.get_date(oebs_scale_dict['endDate']),
            'scale_code': oebs_scale_dict['scaleDescription'],
            'scale_description_en': oebs_scale_dict['scaleDescriptionENG'],
            'scale_description': oebs_scale_dict['scaleDescriptionRUS'],
            'scale_name': oebs_scale_dict['scaleName'],
            'scale_group_femida': oebs_scale_dict['scaleGroupFemida'],
            'scale_group_review': oebs_scale_dict['scaleGroupReview'],
            'scale_group_bonus': oebs_scale_dict['scaleGroupBonus'],
            'scale_group_reward': oebs_scale_dict['scaleGroupReward'],
        }

    def get_iter(self, data):
        for item in data['scales']:
            yield self._occupation_data(item)
