from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class OrganizationDatasource(JsonDatasource):
    @classmethod
    def _oebs_data(cls, data: dict) -> dict:
        return {
            'org_id': data['code'],
            'name_ru': data['taxUnitNameRus'] or '',
            'name_en': data['taxUnitNameEng'] or '',
            'country_code': data['countryCode'] or '',
            'start_date': cls.get_date(data['startDate']),
            'end_date': cls.get_date(data['endDate']),
            'staff_usage': data['staffUsage'],
        }

    def get_iter(self, data):
        for item in data['TaxUnits']:
            yield self._oebs_data(item)
