from typing import Any, Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class ReviewDatasource(JsonDatasource):
    root_field = 'reviewSchemes'
    identity_field = 'schemeID'

    @classmethod
    def get_item(cls, oebs_review_dict: Dict[str, Any]) -> Dict[str, Any]:
        return {
            'name': oebs_review_dict['schemeName'],
            'description': oebs_review_dict['description'],
            'start_date': cls.get_date(oebs_review_dict['startDate']),
            'end_date': cls.get_date(oebs_review_dict['endDate']),
            'scheme_id': oebs_review_dict['schemeID'],
            'schemes_line_id': oebs_review_dict['schemesLineID'],
            'schemes_line_description': oebs_review_dict['schemesLineDesc'],
            'target_bonus': oebs_review_dict['targetBonus'],
            'grant_type': oebs_review_dict['grantType'],
            'grant_type_description': oebs_review_dict['grantTypeDesc'],
        }

    def is_preferred(self, new_candidate: Dict[str, Any], current_candidate: Dict[str, Any]) -> bool:
        if new_candidate['end_date'] is None:
            return True

        if current_candidate['end_date'] is None:
            return False

        return new_candidate['end_date'] > current_candidate['end_date']
