import json

from typing import Dict

from staff.oebs.controllers.datasources.json_datasource import JsonDatasource


class RewardDatasource(JsonDatasource):
    @classmethod
    def _reward_data(cls, oebs_reward_dict: Dict) -> Dict:
        return {
            'name': oebs_reward_dict['schemeName'],
            'description': oebs_reward_dict['description'],
            'start_date': cls.get_date(oebs_reward_dict['startDate']),
            'end_date': cls.get_date(oebs_reward_dict['endDate']),
            'scheme_id': oebs_reward_dict['schemeID'],
            'schemes_line_id': oebs_reward_dict['schemesLineID'],
            'category': oebs_reward_dict['hcCategory'],
            'food': oebs_reward_dict['food'],
            'dms': json.dumps(oebs_reward_dict['dms']),
            'ai': oebs_reward_dict['ai'] and json.dumps(oebs_reward_dict['ai']),
            'dms_group': oebs_reward_dict['dmsGroup'],
            'equipment': oebs_reward_dict['equipment'],
            'mobile': oebs_reward_dict['mob'],
            'bank_cards': json.dumps(oebs_reward_dict['bankCards']),
        }

    def get_iter(self, data):
        for item in data['rewardSchemes']:
            yield self._reward_data(item)
