from staff.lib.sync_tools.data_mapper import DataMapper

from staff.oebs.controllers import converters as conv


class OrganizationDataMapper(DataMapper):
    mapping = (
        ('name_ru', 'name'),
        ('name_en', 'name_en'),
        ('country_code', 'country_code'),
    )


class PlacementDataMapper(DataMapper):
    mapping = (
        ('location_id', 'id'),
        ('location_code', 'name'),
        ('location_addr', 'addr'),
        ('active_status', 'active_status', conv.status),
        ('home_work', 'home_work', conv.yes_no),
    )


class PaysysDataMapper(DataMapper):
    mapping = (
        ('name', 'name'),
        ('description', 'description'),
    )


class OccupationDataMapper(DataMapper):
    mapping = (
        ('scale_name', 'name'),
        ('scale_description', 'description'),
        ('scale_description_en', 'description_en'),
        ('scale_code', 'code'),
        ('scale_group_femida', 'group_femida'),
        ('scale_group_review', 'group_review'),
        ('scale_group_bonus', 'group_bonus'),
        ('scale_group_reward', 'group_reward'),
    )


class EmployeeDataMapper(DataMapper):
    mapping = (
        ('legal_entity_org_id', 'organization_id', conv.organization_id),
    )


class BusinessCenterDataMapper(DataMapper):
    mapping = (
        ('name_ru', 'name'),
        ('name_en', 'name_en'),
    )
