from staff.lib.utils.library import Library

from staff.oebs.controllers.rolluppers.bonus_rollupper import BonusRollupper
from staff.oebs.controllers.rolluppers.business_center_rollupper import BusinessCenterRollupper
from staff.oebs.controllers.rolluppers.currency_rollupper import CurrencyRollupper
from staff.oebs.controllers.rolluppers.employee_rollupper import EmployeeRollupper
from staff.oebs.controllers.rolluppers.geography_rollupper import GeographyRollupper
from staff.oebs.controllers.rolluppers.hr_product_rollupper import HRProductRollupper
from staff.oebs.controllers.rolluppers.leave_balance_rollupper import LeaveBalanceRollupper
from staff.oebs.controllers.rolluppers.occupation_rolluper import OccupationRollupper
from staff.oebs.controllers.rolluppers.oebs_headcount_position_rollupper import OebsHeadcountPositionRollupper
from staff.oebs.controllers.rolluppers.oebs_headcounts_rollupper import OEBSHeadcountsRollupper
from staff.oebs.controllers.rolluppers.organization_rollupper import OrganizationRollupper
from staff.oebs.controllers.rolluppers.paysys_rollupper import PaysysRollupper
from staff.oebs.controllers.rolluppers.person_occupation_rollupper import PersonOccupationRollupper
from staff.oebs.controllers.rolluppers.placement_rolluper import PlacementRollupper
from staff.oebs.controllers.rolluppers.reward_rollupper import RewardRollupper
from staff.oebs.controllers.rolluppers.review_rollupper import ReviewRollupper


rolluppers_library = Library(lambda rollupper: rollupper.model)

rolluppers_library.register(BonusRollupper)
rolluppers_library.register(BusinessCenterRollupper)
rolluppers_library.register(CurrencyRollupper)
rolluppers_library.register(EmployeeRollupper)
rolluppers_library.register(GeographyRollupper)
rolluppers_library.register(HRProductRollupper)
rolluppers_library.register(LeaveBalanceRollupper)
rolluppers_library.register(OEBSHeadcountsRollupper)
rolluppers_library.register(OebsHeadcountPositionRollupper)
rolluppers_library.register(OccupationRollupper)
rolluppers_library.register(OrganizationRollupper)
rolluppers_library.register(PaysysRollupper)
rolluppers_library.register(PersonOccupationRollupper)
rolluppers_library.register(PlacementRollupper)
rolluppers_library.register(RewardRollupper)
rolluppers_library.register(ReviewRollupper)
