from datetime import datetime
from django.conf import settings

from staff.oebs import models as oebs_models
from staff.map.models import Office
from staff.lib.sync_tools.rollupper import Rollupper
from staff.oebs.controllers.mappers import BusinessCenterDataMapper
from staff.oebs.controllers.rolluppers.update_intranet_status import update_intranet_status


class BusinessCenterRollupper(Rollupper):
    model = oebs_models.BusinessCenter
    queryset = oebs_models.BusinessCenter.objects.filter(staff_usage='ДА')
    data_mapper_class = BusinessCenterDataMapper
    link_field_name = 'dis_office'
    key_field_name = 'code'

    def run_rollup(self, object_id=None, dry_run=False):
        super().run_rollup(object_id, dry_run)
        if not dry_run:
            update_intranet_status(self, object_id)

    def create_dis_instance(self, oebs_instance):
        now = datetime.now()
        return Office(
            created_at=now,
            modified_at=now,
            from_staff_id=0,
            color='#0EB555',
            city_id=settings.DEFAULT_CITY_ID,
            tz=settings.TIME_ZONE,
        )
