from datetime import datetime

from staff.lib.sync_tools.data_mapper import DataMapper
from staff.lib.sync_tools.rollupper import Rollupper
from staff.payment.models import Currency

from staff.oebs import models as oebs_models


class CurrencyDataMapper(DataMapper):
    mapping = (
        ('code',),
    )


class CurrencyRollupper(Rollupper):
    model = oebs_models.Currency
    data_mapper_class = CurrencyDataMapper
    link_field_name = 'dis_currency'
    queryset = oebs_models.Currency.objects.all()
    create_absent = True

    def create_dis_instance(self, oebs_instance: oebs_models.Currency) -> Currency:
        now = datetime.now()
        return Currency(code=oebs_instance.code, intranet_status=1, created_at=now, modified_at=now)

    def run_rollup(self, object_id=None, dry_run=False):
        super().run_rollup(object_id, dry_run)

        if not dry_run:
            Currency.objects.filter(oebs_currency__isnull=True).update(intranet_status=0)
