from datetime import datetime

from staff.lib.sync_tools.rollupper import Rollupper
from staff.person import models as person_models
from staff.oebs import models as oebs_models
from staff.oebs.controllers.mappers import OccupationDataMapper


class OccupationRollupper(Rollupper):
    model = oebs_models.Occupation
    data_mapper_class = OccupationDataMapper
    link_field_name = 'dis_occupation'
    key_field_name = 'name'
    rollup_rel_fields = []

    def create_dis_instance(self, oebs_instance: oebs_models.Occupation) -> person_models.Occupation:
        now = datetime.now()
        return person_models.Occupation(
            created_at=now,
            modified_at=now,
            name=oebs_instance.scale_name,
            description=oebs_instance.scale_description,
            description_en=oebs_instance.scale_description_en,
            code=oebs_instance.scale_code,
            group_femida=oebs_instance.scale_group_femida,
            group_review=oebs_instance.scale_group_review,
            group_bonus=oebs_instance.scale_group_bonus,
            group_reward=oebs_instance.scale_group_reward,
        )
