from datetime import datetime

from staff.oebs import models as oebs_models
from staff.person.models import Organization
from staff.lib.sync_tools.rollupper import Rollupper
from staff.oebs.controllers.mappers import OrganizationDataMapper
from staff.oebs.controllers.rolluppers.update_intranet_status import update_intranet_status


class OrganizationRollupper(Rollupper):
    model = oebs_models.Organization
    queryset = oebs_models.Organization.objects.filter(staff_usage='Y')
    data_mapper_class = OrganizationDataMapper
    link_field_name = 'dis_organization'
    key_field_name = 'org_id'

    def run_rollup(self, object_id=None, dry_run=False):
        super().run_rollup(object_id, dry_run)
        if not dry_run:
            update_intranet_status(self, object_id)

    def create_dis_instance(self, oebs_instance):
        now = datetime.now()
        return Organization(
            created_at=now,
            modified_at=now,
            from_staff_id=0,
        )
