from datetime import datetime

from staff.lib.sync_tools.rollupper import Rollupper

from staff.person.models.payment_system import PaymentSystem

from staff.oebs.models import PaySys as OebsPaySys
from staff.oebs.controllers.mappers import PaysysDataMapper


class PaysysRollupper(Rollupper):
    model = OebsPaySys
    data_mapper_class = PaysysDataMapper
    link_field_name = 'dis_paysys'
    key_field_name = 'name'
    rollup_rel_fields = []

    def create_dis_instance(self, oebs_instance: OebsPaySys) -> PaymentSystem:
        now = datetime.now()
        return PaymentSystem(
            created_at=now,
            modified_at=now,
            name=oebs_instance.name,
            description=oebs_instance.description,
        )
