from typing import Set

from django.db import models

from staff.lib.sync_tools.rollupper import Rollupper
from staff.person import models as person_models
from staff.person.controllers import Person

from staff.oebs import models as oebs_models


class PersonOccupationRollupper(Rollupper):
    model = oebs_models.PersonOccupation
    link_field_name = 'dis_staff'
    key_field_name = 'login'
    rollup_rel_fields = (
        ('occupation', {}),
    )

    def rollup_plain_fields(self, oebs_instance: models.Model, dis_instance: models.Model, dry_run: bool) -> Set[str]:
        return set()

    def generic_rollup(
        self,
        oebs_instance,
        dis_instance,
        field_name,
        dry_run: bool,
        extra_field_name=None,
        conv_function=lambda x: x
    ):
        if field_name != 'occupation':
            return False

        person_ctl = Person(dis_instance)
        occupation = self._get_occupation(oebs_instance.occupation)

        if not occupation:
            return False

        if person_ctl.occupation == occupation:
            return False

        person_ctl.occupation = occupation
        if not dry_run:
            person_ctl.save()
        return True

    def _get_occupation(self, occupation: str) -> person_models.Occupation or None:
        if 'occupation' not in self.cache:
            self.cache['occupation'] = {
                occupation_model.name: occupation_model
                for occupation_model in person_models.Occupation.objects.all()
            }

        return self.cache['occupation'].get(occupation)
