from sys import exc_info


class OEBSError(Exception):
    pass


class OEBSSchemaError(OEBSError):
    """Формат пришедших данных не соответствует описанному в моделях"""


class OEBSResponseError(OEBSError):
    """OEBS Proxy ответил ошибкой вместо данных"""


class OEBSConnectionError(OEBSError):
    """Не удалось подключиться к OEBS или неверный код ответа"""


class OEBSPushError(OEBSError):
    """Push-запрос от OEBS пришёл с некорректными данными"""


class OEBSConfigurationError(OEBSError):
    """Допущена ошибка в параметрах синхронизации"""


class OEBSRollupError(OEBSError):
    """Возникла ошибка при накатывании данных"""


class ObjectNotFound(OEBSError):
    """Требуемый объект не найден в БД"""
    def __init__(self, cause, *args, **kwargs):
        self.cause = cause
        self.cause.traceback = exc_info()[2]
        super(ObjectNotFound, self).__init__(*args, **kwargs)
