from optparse import make_option

from django.core.management.base import BaseCommand

from staff.oebs.tasks import LinkTask, LinkAllTask


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option(
            '--nolock',
            action='store_true',
            dest='nolock',
            default=False,
            help='Do not use lock',
        ),
    )

    def handle(self, *args, **options):
        model_name = args[0] if args else None
        nolock = options.get('nolock')

        if model_name:
            LinkTask(model=model_name, nolock=nolock)
        else:
            LinkAllTask(nolock=nolock)
