from optparse import make_option

from django.core.management.base import BaseCommand

from staff.oebs.tasks import SyncAllTask, SyncTask


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option(
            '--delete',
            action='store_true',
            dest='delete',
            default=False,
            help='Delete existing data before synchronization'
        ),
        make_option(
            '--dump-to',
            action='store',
            dest='dump_to',
            default=None,
            help='File to dump XML responses from OEBS Proxy'
        ),
        make_option(
            '--nolock',
            action='store_true',
            dest='nolock',
            default=False,
            help='Do not use lock',
        ),
    )

    def handle(self, *args, **options):
        model_name = args[0] if args else None
        object_id = args[1] if len(args) > 1 else None
        delete = options.get('delete')
        dump_to = options.get('dump_to')

        params = {}
        if model_name:
            params.update(model=model_name)
        if object_id:
            params.update(object_id=object_id)
        if delete:
            params.update(delete=delete)
        if dump_to:
            dump = open(dump_to, 'a')
            params.update(dump_to=dump)
        if options.get('nolock'):
            params.update(nolock=True)

        if model_name:
            SyncTask(**params)
        else:
            SyncAllTask(**params)

        if dump_to:
            dump.close()
