# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('django_intranet_stuff', '0001_initial'),
        ('person', '0001_initial'),
        ('map', '0001_initial'),
        ('departments', '0002_auto_20211007_1807'),
    ]

    operations = [
        migrations.CreateModel(
            name='Bonus',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('scheme_id', models.IntegerField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(null=True)),
                ('description', models.CharField(max_length=255, blank=True, null=True)),
                ('schemes_line_id', models.IntegerField(null=True)),
                ('category', models.CharField(max_length=255, blank=True, null=True)),
                ('value_type', models.CharField(max_length=255, blank=True, null=True)),
                ('value_source', models.CharField(max_length=255, blank=True, null=True)),
                ('value', models.FloatField(null=True)),
                ('scheme_data', models.TextField(max_length=10240, blank=True, null=True)),
                ('dis_bonus', models.OneToOneField(blank=True, null=True, related_name='oebs_bonus', to='departments.Bonus')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BusinessCenter',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('code', models.CharField(verbose_name='Код БЦ', max_length=255)),
                ('name_ru', models.CharField(verbose_name='Название', max_length=255, blank=True, default='')),
                ('name_en', models.CharField(verbose_name='Название на английском', max_length=255, blank=True, default='')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('staff_usage', models.CharField(verbose_name='Используется в стаффе', max_length=4)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Department',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('org_id', models.IntegerField(verbose_name='ID подразделения', blank=True, null=True)),
                ('org_name', models.CharField(verbose_name='Наименование подразделения', max_length=255, blank=True, default='')),
                ('org_short_name', models.CharField(verbose_name='Краткое наименование подразделение', max_length=255, blank=True, default='')),
                ('org_us_name', models.CharField(verbose_name='Наименование на английском', max_length=255, blank=True, default='')),
                ('org_us_short_name', models.CharField(verbose_name='Наименование краткое на английском', max_length=255, blank=True, default='')),
                ('org_full_name', models.CharField(verbose_name='Наименование подразделения кадровое', max_length=255, blank=True, default='')),
                ('active_status', models.CharField(verbose_name='Флаг (Открыта/Закрыта)', max_length=255, blank=True, default='')),
                ('org_order', models.CharField(verbose_name='Сортировка', max_length=255, blank=True, default='')),
                ('manager_guid', models.CharField(verbose_name='GUID Руководителя', max_length=36, blank=True, default='')),
                ('parent_org_id', models.IntegerField(verbose_name='ID подразделения-родителя', blank=True, null=True)),
                ('dis_department', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Department')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Employee',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('person_guid', models.CharField(verbose_name='GUID AD', max_length=36, blank=True, default='')),
                ('last_name', models.CharField(verbose_name='Фамилия сотрудника', max_length=255, blank=True, default='')),
                ('first_name', models.CharField(verbose_name='Имя сотрудника', max_length=255, blank=True, default='')),
                ('middle_names', models.CharField(verbose_name='Отчество сотрудника', max_length=255, blank=True, default='')),
                ('date_start', models.CharField(verbose_name='Дата приема', max_length=255, blank=True, default='')),
                ('actual_termination_date', models.CharField(verbose_name='Дата увольнения', max_length=255, blank=True, default='')),
                ('manage_org_id', models.IntegerField(verbose_name='ID подразделения', blank=True, null=True)),
                ('legal_entity_org_id', models.IntegerField(verbose_name='ID организации', blank=True, null=True)),
                ('office_loc_id', models.IntegerField(verbose_name='ID офиса', blank=True, null=True)),
                ('home_loc_id', models.IntegerField(verbose_name='ID временного офиса', blank=True, null=True)),
                ('home_flag', models.CharField(verbose_name='Признак фиктивного надомника', max_length=255, blank=True, default='')),
                ('person_type', models.CharField(verbose_name='Тип сотрудника', max_length=255, blank=True, default='')),
                ('concatenated_address', models.CharField(verbose_name='Адрес проживания', max_length=255, blank=True, default='')),
                ('manage_org_name', models.CharField(verbose_name='Кадровое наименование подразделения', max_length=255, blank=True, default='')),
                ('job_name', models.CharField(verbose_name='Кадровое наименование должности', max_length=255, blank=True, default='')),
                ('child_count', models.IntegerField(verbose_name='Количество детей', blank=True, null=True)),
                ('nda_end_date', models.CharField(verbose_name='Дата окончания действия NDA', max_length=255, blank=True, default='')),
                ('contract_end_date', models.CharField(verbose_name='Дата окончания договора', max_length=255, blank=True, default='')),
                ('byod_access', models.CharField(verbose_name='Доступ в PDAS', max_length=3, blank=True, default='')),
                ('wiretap', models.CharField(verbose_name='Согласен на запись телефонных разговоров', max_length=1, blank=True, default='')),
                ('headcount', models.DecimalField(verbose_name='Cчитается ли человек в headcount', blank=True, null=True, max_digits=20, decimal_places=10)),
                ('jobprice', models.IntegerField(verbose_name='jobprice', blank=True, null=True)),
                ('staff_agreement', models.CharField(verbose_name='Cогласен на обработку моих ПД', max_length=1, blank=True, default='')),
                ('dis_staff', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Geography',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('code', models.CharField(primary_key=True, max_length=32, serialize=False)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(null=True)),
                ('description', models.CharField(max_length=255, blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HeadcountPosition',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('id', models.CharField(primary_key=True, max_length=64, serialize=False)),
                ('position_code', models.IntegerField()),
                ('org_id', models.IntegerField(verbose_name='ID подразделения', db_index=True)),
                ('org_summary', models.CharField(max_length=1024, default='')),
                ('position_status', models.CharField(max_length=32, choices=[('OCCUPIED', 'OCCUPIED'), ('OFFER', 'OFFER'), ('VACANCY_OPEN', 'VACANCY_OPEN'), ('VACANCY_PLAN', 'VACANCY_PLAN'), ('RESERVE', 'RESERVE'), ('MATERNITY', 'MATERNITY')])),
                ('position_category_is_new', models.BooleanField()),
                ('position_name', models.CharField(max_length=128)),
                ('position_product_id', models.IntegerField()),
                ('position_geo', models.CharField(max_length=16)),
                ('position_bonus_id', models.IntegerField()),
                ('position_reward_id', models.IntegerField()),
                ('position_review_id', models.IntegerField()),
                ('position_current_login', models.CharField(max_length=25, null=True)),
                ('position_previous_login', models.CharField(max_length=25, null=True)),
                ('position_headcount', models.IntegerField(verbose_name='headcount позиции')),
                ('position_is_crossing', models.BooleanField(default=False)),
                ('relevance_date', models.DateField()),
                ('position_main_assignment', models.BooleanField(default=True)),
                ('position_in_total_hc', models.BooleanField(default=False)),
                ('position_index', models.IntegerField(db_index=True, default=1)),
                ('position_prev_index', models.IntegerField(null=True)),
                ('position_next_index', models.IntegerField(null=True)),
                ('position_replacement_type', models.CharField(max_length=32, default='WO_REPLACEMENT', choices=[('HAS_REPLACEMENT', 'HAS_REPLACEMENT'), ('HC_IS_BUSY', 'HC_IS_BUSY'), ('HAS_REPLACEMENT_AND_HC_IS_BUSY', 'HAS_REPLACEMENT_AND_HC_IS_BUSY'), ('WO_REPLACEMENT', 'WO_REPLACEMENT')])),
                ('total_headcount', models.IntegerField(verbose_name='headcount подразделения', default=0)),
                ('state_position_type', models.CharField(max_length=32, db_index=True, default='', choices=[('OCCUPIED_NEW', 'OCCUPIED_NEW'), ('OCCUPIED_REPLACEMENT', 'OCCUPIED_REPLACEMENT'), ('OFFER_NEW', 'OFFER_NEW'), ('OFFER_REPLACEMENT', 'OFFER_REPLACEMENT'), ('VACANCY_OPEN_NEW', 'VACANCY_OPEN_NEW'), ('VACANCY_OPEN_REPLACEMENT', 'VACANCY_OPEN_REPLACEMENT'), ('VACANCY_PLAN_NEW', 'VACANCY_PLAN_NEW'), ('VACANCY_PLAN_REPLACEMENT', 'VACANCY_PLAN_REPLACEMENT'), ('RESERVE_NEW', 'RESERVE_NEW'), ('MATERNITY_NEW', 'MATERNITY_NEW'), ('MATERNITY_REPLACEMENT', 'MATERNITY_REPLACEMENT')])),
                ('state_headcount', models.IntegerField(verbose_name='headcount позиций этого типа', default=0)),
                ('state_cross_headcount', models.IntegerField(verbose_name='headcount позиций с пересечениями этого типа', default=0)),
                ('departments_headcountposition', models.ForeignKey(blank=True, null=True, to='departments.HeadcountPosition')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HRProduct',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('product_id', models.IntegerField(primary_key=True, serialize=False)),
                ('end_date', models.DateField(null=True)),
                ('product_name', models.CharField(max_length=255, blank=True, null=True)),
                ('service_code', models.CharField(max_length=255, blank=True, null=True)),
                ('service_name', models.CharField(max_length=255, blank=True, null=True)),
                ('service_abc', models.CharField(max_length=16, blank=True, null=True)),
                ('dis_hr_product', models.ForeignKey(blank=True, null=True, related_name='+', to='departments.HRProduct')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Job',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('code', models.IntegerField(primary_key=True, serialize=False)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(null=True)),
                ('name', models.CharField(max_length=255, blank=True, null=True)),
                ('name_en', models.CharField(max_length=255, blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='LeaveBalance',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('person_guid', models.CharField(verbose_name='GUID AD', max_length=36, blank=True, default='')),
                ('leave_balance_default', models.CharField(verbose_name='Неизрасходованные дни отпуска', max_length=50, blank=True, default='')),
                ('leave_balance_company', models.CharField(verbose_name='Неизрасходованные доп. дни отпуска ', max_length=50, blank=True, default='')),
                ('time_off', models.CharField(verbose_name='Неизрасходованные отгулы', max_length=50, blank=True, default='')),
                ('dis_staff', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Occupation',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('end_date', models.DateField(verbose_name='Дата до которой действует шкала', null=True)),
                ('scale_name', models.CharField(verbose_name='Значение шкалы', primary_key=True, max_length=255, serialize=False)),
                ('scale_code', models.CharField(verbose_name='Описание шкалы (код)', max_length=255, null=True)),
                ('scale_description', models.CharField(verbose_name='Описание шкалы на русском', max_length=255, null=True)),
                ('scale_description_en', models.CharField(verbose_name='Описание шкалы на английском', max_length=255)),
                ('scale_group_femida', models.CharField(max_length=255, null=True)),
                ('scale_group_review', models.CharField(max_length=255, null=True)),
                ('scale_group_bonus', models.CharField(max_length=255, null=True)),
                ('scale_group_reward', models.CharField(max_length=255, null=True)),
                ('dis_occupation', models.ForeignKey(blank=True, null=True, to='person.Occupation')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Office',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('location_id', models.IntegerField(verbose_name='ID офиса', blank=True, null=True)),
                ('location_code', models.CharField(verbose_name='Наименование расположения', max_length=255, blank=True, default='')),
                ('location_addr', models.CharField(verbose_name='Адрес', max_length=255, blank=True, default='')),
                ('taxunit_code', models.IntegerField(verbose_name='Код юр.лица', blank=True, null=True)),
                ('businesscentre_code', models.CharField(verbose_name='Код БЦ', max_length=255, blank=True, null=True)),
                ('home_work', models.CharField(verbose_name='Флаг (надомник)', max_length=255, blank=True, default='')),
                ('active_status', models.CharField(verbose_name='Флаг наличия', max_length=255, blank=True, default='')),
                ('dis_placement', models.ForeignKey(blank=True, null=True, related_name='+', to='map.Placement')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Organization',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('org_id', models.IntegerField(verbose_name='ID организации', blank=True, null=True)),
                ('name_ru', models.CharField(verbose_name='Название', max_length=255, blank=True, default='')),
                ('name_en', models.CharField(verbose_name='Название на английском', max_length=255, blank=True, default='')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('staff_usage', models.CharField(verbose_name='Используется в стаффе', max_length=4)),
                ('dis_organization', models.OneToOneField(blank=True, null=True, related_name='oebs_organization', to='django_intranet_stuff.Organization')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PaySys',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('name', models.CharField(primary_key=True, max_length=255, serialize=False)),
                ('description', models.CharField(max_length=512, blank=True, null=True)),
                ('dis_paysys', models.ForeignKey(blank=True, null=True, to='person.PaymentSystem')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PersonOccupation',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('login', models.CharField(primary_key=True, max_length=50, serialize=False)),
                ('occupation', models.CharField(max_length=255)),
                ('dis_staff', models.ForeignKey(blank=True, null=True, to='django_intranet_stuff.Staff')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Review',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('scheme_id', models.IntegerField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(null=True)),
                ('description', models.CharField(max_length=255, blank=True, null=True)),
                ('schemes_line_id', models.IntegerField(null=True)),
                ('schemes_line_description', models.CharField(max_length=255, blank=True, null=True)),
                ('target_bonus', models.FloatField(null=True)),
                ('grant_type', models.CharField(max_length=255, blank=True, null=True)),
                ('grant_type_description', models.CharField(max_length=255, blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Reward',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('scheme_id', models.IntegerField(primary_key=True, serialize=False)),
                ('name', models.CharField(max_length=255)),
                ('start_date', models.DateField()),
                ('end_date', models.DateField(null=True)),
                ('description', models.CharField(max_length=255, blank=True, null=True)),
                ('schemes_line_id', models.IntegerField(null=True)),
                ('category', models.CharField(max_length=255, blank=True, null=True)),
                ('food', models.CharField(max_length=255, blank=True, null=True)),
                ('dms', models.TextField(blank=True, null=True)),
                ('ai', models.TextField(blank=True, null=True)),
                ('dms_group', models.CharField(max_length=255, blank=True, null=True)),
                ('equipment', models.CharField(max_length=255, blank=True, null=True)),
                ('mobile', models.CharField(max_length=255, blank=True, null=True)),
                ('bank_cards', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StoredResponse',
            fields=[
                ('id', models.AutoField(verbose_name='ID', primary_key=True, serialize=False, auto_created=True)),
                ('code', models.IntegerField()),
                ('entity', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_auto_removable', models.BooleanField(default=True)),
                ('s3_key', models.CharField(max_length=255)),
            ],
        ),
        migrations.AddField(
            model_name='businesscenter',
            name='dis_office',
            field=models.OneToOneField(blank=True, null=True, related_name='oebs_businesscenter', to='django_intranet_stuff.Office'),
        ),
    ]
