# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('budget_position', '0010_budget_position_assignment_oebs_links'),
        ('oebs', '0003_employee_staff_biometric_agreement'),
    ]

    operations = [
        migrations.CreateModel(
            name='OebsHeadcountPosition',
            fields=[
                ('last_sync', models.DateTimeField(verbose_name='Дата выгрузки', blank=True, null=True)),
                ('last_rollup', models.DateTimeField(verbose_name='Дата накатки', blank=True, null=True)),
                ('last_rollup_error', models.TextField(verbose_name='Последняя ошибка накатки', blank=True, default='')),
                ('rollup_warnings', models.TextField(verbose_name='Предупреждения накатки', blank=True, default='')),
                ('st_translation_id', models.IntegerField(verbose_name='id от объекта translation из startrek', blank=True, null=True)),
                ('id', models.CharField(primary_key=True, max_length=64, serialize=False)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('code', models.IntegerField()),
                ('name', models.CharField(max_length=128)),
                ('status', models.CharField(max_length=32)),
                ('state2', models.CharField(max_length=32)),
                ('relevance_date', models.DateField()),
                ('headcount', models.IntegerField()),
                ('main_assignment', models.BooleanField(default=True)),
                ('is_total_hc', models.BooleanField(default=False)),
                ('department_id', models.IntegerField()),
                ('hr_product_id', models.IntegerField()),
                ('geography_oebs_code', models.CharField(max_length=16)),
                ('bonus_id', models.IntegerField()),
                ('reward_id', models.IntegerField()),
                ('review_id', models.IntegerField()),
                ('current_login', models.CharField(max_length=25, null=True)),
                ('previous_login', models.CharField(max_length=25, null=True)),
                ('assignment_index', models.IntegerField(default=1)),
                ('prev_assignment_index', models.IntegerField(null=True)),
                ('next_assignment_index', models.IntegerField(null=True)),
                ('dis_budget_position_assignment', models.OneToOneField(blank=True, null=True, related_name='oebs_headcount_position', to='budget_position.BudgetPositionAssignment')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
