from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import BonusDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Bonus(OEBSModelBase):
    """Справочник схем премирования"""
    oebs_type = OEBS_RESOURCE_NAME.BONUS
    method = REQUEST_METHOD.GET
    datasource_class = BonusDatasource

    scheme_id = models.IntegerField(
        primary_key=True,
    )

    name = models.CharField(
        null=False,
        max_length=255,
    )

    start_date = models.DateField(
        null=False,
    )

    end_date = models.DateField(
        null=True,
    )

    description = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    schemes_line_id = models.IntegerField(
        null=True,
    )

    category = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    value_type = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    value_source = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    value = models.FloatField(
        null=True,
    )

    scheme_data = models.TextField(
        null=True,
        blank=True,
        max_length=10240,
    )

    dis_bonus = models.OneToOneField(
        'departments.Bonus',
        blank=True,
        null=True,
        related_name='oebs_bonus',
    )

    def __str__(self):
        return '{name}'.format(**vars(self))
