from django.db import models

from staff.oebs.constants import REQUEST_METHOD, OEBS_RESOURCE_NAME
from staff.oebs.models.oebs_model_base import OEBSModelBase, library
from staff.oebs.controllers.datasources import BusinessCenterDatasource


@library.register
class BusinessCenter(OEBSModelBase):
    """Бизнес-центры (стаффовские офисы) из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.BUSINESS_CENTER
    method = REQUEST_METHOD.GET
    datasource_class = BusinessCenterDatasource
    link_field_name = 'dis_office'

    code = models.CharField(
        max_length=255,
        verbose_name='Код БЦ',
    )

    name_ru = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name='Название',
    )

    name_en = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name='Название на английском'
    )

    start_date = models.DateField(
        blank=True,
        null=True,
    )

    end_date = models.DateField(
        blank=True,
        null=True,
    )

    staff_usage = models.CharField(
        verbose_name='Используется в стаффе',
        max_length=4,
    )

    dis_office = models.OneToOneField(
        'django_intranet_stuff.Office',
        blank=True,
        null=True,
        related_name='oebs_businesscenter',
    )

    def __str__(self):
        return '{name_ru} ({code})'.format(**vars(self))
