from django.db import models

from staff.oebs.constants import REQUEST_METHOD, OEBS_RESOURCE_NAME
from staff.oebs.controllers.datasources import CurrencyDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Currency(OEBSModelBase):
    """Коды валют"""
    oebs_type = OEBS_RESOURCE_NAME.CURRENCY
    method = REQUEST_METHOD.GET
    datasource_class = CurrencyDatasource

    code = models.CharField(max_length=4)
    dis_currency = models.OneToOneField(
        'payment.Currency',
        blank=True,
        null=True,
        related_name='oebs_currency',
    )

    def __str__(self):
        return f'{self.code}'
