from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import XmlDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Employee(OEBSModelBase):
    """Сотрудники из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.PERSON
    method = REQUEST_METHOD.POST
    datasource_class = XmlDatasource
    link_field_name = 'dis_staff'

    person_guid = models.CharField(
        blank=True,
        max_length=36,
        default='',
        verbose_name="GUID AD",
    )
    last_name = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Фамилия сотрудника",
    )
    first_name = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Имя сотрудника",
    )
    middle_names = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Отчество сотрудника",
    )
    date_start = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Дата приема",
    )
    actual_termination_date = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Дата увольнения",
    )
    manage_org_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name="ID подразделения",
    )
    legal_entity_org_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name="ID организации",
    )
    office_loc_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name="ID офиса",
    )
    home_loc_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name="ID временного офиса",
    )
    home_flag = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Признак фиктивного надомника",
    )
    person_type = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Тип сотрудника",
    )
    concatenated_address = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Адрес проживания",
    )
    manage_org_name = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Кадровое наименование подразделения",
    )
    job_name = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Кадровое наименование должности",
    )
    child_count = models.IntegerField(
        null=True,
        blank=True,
        verbose_name="Количество детей",
    )
    nda_end_date = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Дата окончания действия NDA",
    )
    contract_end_date = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Дата окончания договора",
    )
    byod_access = models.CharField(
        blank=True,
        max_length=3,
        default='',
        verbose_name="Доступ в PDAS",
    )
    wiretap = models.CharField(
        blank=True,
        max_length=1,
        default='',
        verbose_name='Согласен на запись телефонных разговоров'
    )
    dis_staff = models.ForeignKey(
        'django_intranet_stuff.Staff',
        blank=True,
        null=True,
    )
    headcount = models.DecimalField(
        null=True,
        blank=True,
        decimal_places=10,
        max_digits=20,
        verbose_name='Cчитается ли человек в headcount',
    )
    jobprice = models.IntegerField(
        null=True,
        blank=True,
        verbose_name='jobprice',
    )
    staff_agreement = models.CharField(
        blank=True,
        max_length=1,
        default='',
        verbose_name='Cогласен на обработку моих ПД',
    )
    staff_biometric_agreement = models.CharField(
        blank=True,
        max_length=1,
        default='',
        verbose_name='Cогласен на обработку моих БиоПД',
    )

    def __str__(self):
        return '{first_name} {last_name}'.format(**vars(self))
