from django.db import models

from staff.departments.models import Geography as StaffGeography

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import GeographyDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Geography(OEBSModelBase):
    """Справочник географий, которые используются в HR"""
    oebs_type = OEBS_RESOURCE_NAME.GEOGRAPHY
    method = REQUEST_METHOD.GET
    datasource_class = GeographyDatasource

    code = models.CharField(primary_key=True, null=False, max_length=32)
    start_date = models.DateField(null=False)
    end_date = models.DateField(null=True)
    description = models.CharField(max_length=255, null=True, blank=True)
    staff_geography = models.ForeignKey(StaffGeography, blank=True, null=True, related_name='+')

    def __str__(self):
        return '{description} ({code})'.format(**vars(self))
