from django.db import models

from staff.departments.models import HeadcountPosition as DepartmentsHeadcountPosition

from staff.oebs.constants import (
    OEBS_RESOURCE_NAME,
    PERSON_POSITION_STATUS,
    POSITION_TYPE,
    REQUEST_METHOD,
    REPLACEMENT_TYPE,
)
from staff.oebs.controllers.datasources import HeadcountPositionsDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class HeadcountPosition(OEBSModelBase):
    """Потолки из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.HEADCOUNT
    method = REQUEST_METHOD.POST
    datasource_class = HeadcountPositionsDatasource

    id = models.CharField(
        primary_key=True,
        null=False,
        blank=False,
        max_length=64,
    )

    position_code = models.IntegerField(
        null=False,
    )

    org_id = models.IntegerField(
        null=False,
        blank=False,
        verbose_name='ID подразделения',
        db_index=True,
    )

    org_summary = models.CharField(max_length=1024, default='')

    position_status = models.CharField(
        choices=PERSON_POSITION_STATUS,
        null=False,
        blank=False,
        max_length=32,
    )

    position_category_is_new = models.BooleanField(
        null=False,
        blank=False,
    )

    position_name = models.CharField(
        null=False,
        blank=False,
        max_length=128,
    )

    position_product_id = models.IntegerField(
        null=False,
        blank=False,
    )

    position_geo = models.CharField(
        null=False,
        blank=False,
        max_length=16,
    )

    position_bonus_id = models.IntegerField(
        null=False,
        blank=False,
    )

    position_reward_id = models.IntegerField(
        null=False,
        blank=False,
    )

    position_review_id = models.IntegerField(
        null=False,
        blank=False,
    )

    position_current_login = models.CharField(
        max_length=25,
        null=True,
        blank=False,
    )

    position_previous_login = models.CharField(
        max_length=25,
        null=True,
        blank=False,
    )

    position_headcount = models.IntegerField(
        null=False,
        blank=False,
        verbose_name='headcount позиции',
    )

    position_is_crossing = models.BooleanField(
        null=False,
        blank=False,
        default=False,
    )

    relevance_date = models.DateField(
        null=False,
        blank=False,
    )

    departments_headcountposition = models.ForeignKey(
        DepartmentsHeadcountPosition,
        blank=True,
        null=True,
    )

    position_main_assignment = models.BooleanField(
        null=False,
        blank=False,
        default=True,
    )

    position_in_total_hc = models.BooleanField(
        null=False,
        blank=False,
        default=False,
    )
    position_index = models.IntegerField(null=False, db_index=True, default=1)
    position_prev_index = models.IntegerField(null=True)
    position_next_index = models.IntegerField(null=True)
    position_replacement_type = models.CharField(
        choices=REPLACEMENT_TYPE,
        null=False,
        blank=False,
        max_length=32,
        default=REPLACEMENT_TYPE.WO_REPLACEMENT,
    )

    # todo: Следующие поля надо удалить
    total_headcount = models.IntegerField(
        null=False,
        blank=False,
        verbose_name='headcount подразделения',
        default=0
    )
    state_position_type = models.CharField(
        choices=POSITION_TYPE,
        null=False,
        blank=False,
        max_length=32,
        db_index=True,
        default='',
    )
    state_headcount = models.IntegerField(
        null=False,
        blank=False,
        verbose_name='headcount позиций этого типа',
        default=0
    )
    state_cross_headcount = models.IntegerField(
        null=False,
        blank=False,
        verbose_name='headcount позиций с пересечениями этого типа',
        default=0
    )

    def __str__(self):
        return (
            '{position_code}({position_name}) {state_position_type} Dep:{org_id}'
        ).format(**vars(self))
