from django.db import models

from staff.departments.models import HRProduct as Dis_HRProduct
from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import HRProductDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class HRProduct(OEBSModelBase):
    """HR-продукт или Value Stream"""
    oebs_type = OEBS_RESOURCE_NAME.HR_PRODUCT
    method = REQUEST_METHOD.GET
    datasource_class = HRProductDatasource

    product_id = models.IntegerField(
        primary_key=True,
        null=False,
    )
    end_date = models.DateField(
        null=True,
    )
    product_name = models.CharField(
        max_length=255,
        null=True,
        blank=True,
    )
    service_code = models.CharField(
        max_length=255,
        null=True,
        blank=True,
    )
    service_name = models.CharField(
        max_length=255,
        null=True,
        blank=True,
    )
    service_abc = models.CharField(
        max_length=16,
        null=True,
        blank=True,
    )
    dis_hr_product = models.ForeignKey(
        Dis_HRProduct,
        blank=True,
        null=True,
        related_name='+',
    )

    def __str__(self):
        return '{product_id} ({product_name})'.format(**vars(self))
