from django.db import models

from staff.lib.models.base import AtomicSaveModel

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources.jobs_datasource import JobsDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Job(OEBSModelBase, AtomicSaveModel):
    """Кадровые должности"""
    oebs_type = OEBS_RESOURCE_NAME.JOB
    method = REQUEST_METHOD.GET
    datasource_class = JobsDatasource

    code = models.IntegerField(
        primary_key=True,
        null=False,
    )
    start_date = models.DateField(
        null=False,
    )
    end_date = models.DateField(
        null=True,
    )
    name = models.CharField(
        max_length=255,
        null=True,
        blank=True,
    )
    name_en = models.CharField(
        max_length=255,
        null=True,
        blank=True,
    )

    is_deleted_from_oebs = models.BooleanField(default=False)

    def __str__(self):
        return '{name_en} ({code})'.format(**vars(self))
