from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import XmlDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class LeaveBalance(OEBSModelBase):
    """Дни отпуска и отгулы из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.LEAVE_BALANCE
    method = REQUEST_METHOD.POST
    datasource_class = XmlDatasource

    link_field_name = 'dis_staff'

    person_guid = models.CharField(
        blank=True,
        max_length=36,
        default='',
        verbose_name="GUID AD",
    )
    leave_balance_default = models.CharField(
        blank=True,
        max_length=50,
        default='',
        verbose_name='Неизрасходованные дни отпуска'
    )
    leave_balance_company = models.CharField(
        blank=True,
        max_length=50,
        default='',
        verbose_name='Неизрасходованные доп. дни отпуска '
    )
    time_off = models.CharField(
        blank=True,
        max_length=50,
        default='',
        verbose_name='Неизрасходованные отгулы'
    )
    dis_staff = models.ForeignKey(
        'django_intranet_stuff.Staff',
        blank=True,
        null=True,
    )

    def __str__(self):
        return '{person_guid}: {leave_balance_default} {time_off}'.format(**vars(self))
