from django.db import models

from staff.lib.models.base import AtomicSaveModel

from staff.person import models as person_models
from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import OccupationDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Occupation(OEBSModelBase, AtomicSaveModel):
    """Шкала (справочник профессий)"""
    oebs_type = OEBS_RESOURCE_NAME.OCCUPATION
    method = REQUEST_METHOD.GET
    datasource_class = OccupationDatasource

    end_date = models.DateField(
        null=True,
        verbose_name='Дата до которой действует шкала',
    )
    scale_name = models.CharField(
        primary_key=True,
        max_length=255,
        verbose_name='Значение шкалы',
    )
    scale_code = models.CharField(
        max_length=255,
        verbose_name='Описание шкалы (код)',
        null=True,
    )
    scale_description = models.CharField(
        max_length=255,
        verbose_name='Описание шкалы на русском',
        null=True,
    )
    scale_description_en = models.CharField(
        max_length=255,
        verbose_name='Описание шкалы на английском',
    )
    dis_occupation = models.ForeignKey(
        person_models.Occupation,
        blank=True,
        null=True,
    )
    scale_group_femida = models.CharField(
        null=True,
        max_length=255,
    )
    scale_group_review = models.CharField(
        null=True,
        max_length=255,
    )
    scale_group_bonus = models.CharField(
        null=True,
        max_length=255,
    )
    scale_group_reward = models.CharField(
        null=True,
        max_length=255,
    )

    def __str__(self):
        return '{scale_name} ({scale_code})'.format(**vars(self))
