from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources.oebs_headcount_positions_datasource import OebsHeadcountPositionsDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class OebsHeadcountPosition(OEBSModelBase):
    """Потолки из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.HEADCOUNT
    method = REQUEST_METHOD.POST
    datasource_class = OebsHeadcountPositionsDatasource

    id = models.CharField(primary_key=True, null=False, max_length=64)

    code = models.IntegerField(null=False)
    name = models.CharField(null=False, max_length=128)
    status = models.CharField(null=False, max_length=32)
    state2 = models.CharField(null=False, max_length=32)
    relevance_date = models.DateField(null=False)

    headcount = models.IntegerField(null=False)
    main_assignment = models.BooleanField(null=False, default=True)
    is_total_hc = models.BooleanField(null=False, default=False)

    department_id = models.IntegerField(null=False)
    hr_product_id = models.IntegerField(null=False)
    geography_oebs_code = models.CharField(null=False, max_length=16)

    bonus_id = models.IntegerField(null=False)
    reward_id = models.IntegerField(null=False)
    review_id = models.IntegerField(null=False)

    current_login = models.CharField(max_length=25, null=True)
    previous_login = models.CharField(max_length=25, null=True)
    assignment_index = models.IntegerField(null=False, default=1)
    prev_assignment_index = models.IntegerField(null=True)
    next_assignment_index = models.IntegerField(null=True)
    assignment_id = models.BigIntegerField(null=True, db_index=True)
    batch_id = models.BigIntegerField(null=True)

    has_errors = models.BooleanField(default=False)

    dis_budget_position_assignment = models.OneToOneField(
        'budget_position.BudgetPositionAssignment',
        blank=True,
        null=True,
        related_name='oebs_headcount_position',
    )

    class Meta:
        index_together = ('code', 'assignment_index')
