from django.db import models

from staff.map.models import Placement
from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import XmlDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Office(OEBSModelBase):
    """Расположения (не офисы) из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.OFFICE
    method = REQUEST_METHOD.POST
    datasource_class = XmlDatasource

    location_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name='ID офиса',
    )

    location_code = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name='Наименование расположения',
    )

    location_addr = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name='Адрес',
    )

    taxunit_code = models.IntegerField(
        null=True,
        blank=True,
        verbose_name='Код юр.лица',
    )

    businesscentre_code = models.CharField(
        null=True,
        blank=True,
        verbose_name='Код БЦ',
        max_length=255,
    )

    home_work = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Флаг (надомник)",
    )

    active_status = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name="Флаг наличия",
    )

    dis_placement = models.ForeignKey(
        Placement,
        blank=True,
        null=True,
        related_name='+',
    )

    def __str__(self):
        return '{location_code}'.format(**vars(self))
