from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import OrganizationDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Organization(OEBSModelBase):
    """Организации (Юр.Лица) из OEBS"""
    oebs_type = OEBS_RESOURCE_NAME.TAX_UNIT
    method = REQUEST_METHOD.GET
    datasource_class = OrganizationDatasource
    link_field_name = 'dis_organization'

    org_id = models.IntegerField(
        null=True,
        blank=True,
        verbose_name="ID организации",
    )

    name_ru = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name='Название',
    )

    name_en = models.CharField(
        blank=True,
        max_length=255,
        default='',
        verbose_name='Название на английском'
    )

    country_code = models.CharField(
        verbose_name='Код страны',
        max_length=3,
        blank=True,
        default='',
    )

    start_date = models.DateField(
        blank=True,
        null=True,
    )

    end_date = models.DateField(
        blank=True,
        null=True,
    )

    staff_usage = models.CharField(
        verbose_name='Используется в стаффе',
        max_length=4,
    )

    dis_organization = models.OneToOneField(
        'django_intranet_stuff.Organization',
        blank=True,
        null=True,
        related_name='oebs_organization',
    )

    def __str__(self):
        return '{name_ru} ({org_id})'.format(**vars(self))
