from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import PaySysDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library
from staff.person.models import PaymentSystem


@library.register
class PaySys(OEBSModelBase):
    """Справочник схем систем оплаты труда"""
    oebs_type = OEBS_RESOURCE_NAME.PAYSYS
    method = REQUEST_METHOD.GET
    datasource_class = PaySysDatasource

    dis_paysys = models.ForeignKey(
        PaymentSystem,
        blank=True,
        null=True,
    )
    name = models.CharField(
        primary_key=True,
        null=False,
        max_length=255,
    )
    description = models.CharField(
        null=True,
        blank=True,
        max_length=512,
    )

    def __str__(self):
        return '{name}'.format(**vars(self))
