from django.db import models

from staff.person.models import Staff

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import PersonOccupationDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class PersonOccupation(OEBSModelBase):
    oebs_type = OEBS_RESOURCE_NAME.GRADE_HIST
    method = REQUEST_METHOD.POST
    datasource_class = PersonOccupationDatasource
    link_field_name = 'dis_staff'

    login = models.CharField(primary_key=True, max_length=50)
    occupation = models.CharField(max_length=255)
    dis_staff = models.ForeignKey(Staff, blank=True, null=True)
