from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import ReviewDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Review(OEBSModelBase):
    """Справочник схем ревью"""
    oebs_type = OEBS_RESOURCE_NAME.REVIEW
    method = REQUEST_METHOD.GET
    datasource_class = ReviewDatasource

    scheme_id = models.IntegerField(
        primary_key=True,
    )

    name = models.CharField(
        null=False,
        max_length=255,
    )

    start_date = models.DateField(
        null=False,
    )

    end_date = models.DateField(
        null=True,
    )

    description = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    schemes_line_id = models.IntegerField(
        null=True,
    )

    schemes_line_description = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    target_bonus = models.FloatField(
        null=True,
    )

    grant_type = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    grant_type_description = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    dis_instance = models.OneToOneField(
        'budget_position.Review',
        blank=True,
        null=True,
        related_name='oebs_instance',
    )

    def __str__(self):
        return '{name}'.format(**vars(self))
