from django.db import models

from staff.oebs.constants import OEBS_RESOURCE_NAME, REQUEST_METHOD
from staff.oebs.controllers.datasources import RewardDatasource
from staff.oebs.models.oebs_model_base import OEBSModelBase, library


@library.register
class Reward(OEBSModelBase):
    """Справочник схем компенсаций"""
    oebs_type = OEBS_RESOURCE_NAME.REWARD
    method = REQUEST_METHOD.GET
    datasource_class = RewardDatasource

    scheme_id = models.IntegerField(
        primary_key=True,
    )

    name = models.CharField(
        null=False,
        max_length=255,
    )

    start_date = models.DateField(
        null=False,
    )

    end_date = models.DateField(
        null=True,
    )

    description = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    schemes_line_id = models.IntegerField(
        null=True,
    )

    category = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    food = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    dms = models.TextField(
        null=True,
        blank=True,
    )

    ai = models.TextField(
        null=True,
        blank=True,
    )

    dms_group = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    equipment = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    mobile = models.CharField(
        null=True,
        blank=True,
        max_length=255,
    )

    bank_cards = models.TextField(
        null=True,
        blank=True,
    )

    dis_instance = models.OneToOneField(
        'budget_position.Reward',
        blank=True,
        null=True,
        related_name='oebs_instance',
    )

    def __str__(self):
        return '{name}'.format(**vars(self))
