from staff.lib.models import verbose_name

from .utils import is_primitive


class SimpleField(object):
    def __init__(self, model, field):
        self.model = model
        self.field = field

    @property
    def verbose_name(self):
        return verbose_name(self.model, self.field)

    @property
    def required_values(self):
        return self.field,

    def __call__(self, obj, report):
        return obj[self.field]


def maybe_wrap_field(model, field):
    if is_primitive(field):
        return SimpleField(model, field)
    return field
