from django.db.models import Q

from staff.lib.models import smart_model

from staff.oebs.reports.base import Report
from staff.oebs.reports.utils import maybe_isodate_to_string, field_spec


class UnlinkedEmployees(Report):
    queryset = smart_model('oebs.Employee').unlinked.all()
    fields = (
        field_spec('first_name',),
        field_spec('last_name',),
        field_spec('person_guid',),
        field_spec('date_start',),
        field_spec('last_sync', maybe_isodate_to_string),
    )
    order = ('date_start',)


class FiredEmployees(Report):
    queryset = (
        smart_model('oebs.Employee').linked
        .filter(
            Q(actual_termination_date='', dis_staff__is_dismissed=True) |
            (~Q(actual_termination_date='') & Q(dis_staff__is_dismissed=False))
        )
    )
    fields = (
        field_spec('first_name',),
        field_spec('last_name',),
        field_spec('dis_staff__login',),
        field_spec('person_guid',),
        field_spec('dis_staff__quit_at', maybe_isodate_to_string),
        field_spec('actual_termination_date',),
        field_spec('last_sync', maybe_isodate_to_string),
    )
    order = ('dis_staff__login',)
