from django.contrib.auth.decorators import permission_required

from staff.lib.decorators import responding_xlsx

from staff.oebs.reports.reports import UnlinkedEmployees, FiredEmployees


@permission_required(
    'django_intranet_stuff.can_view_oebs_unlinked_employees_report',
    raise_exception=True)
@responding_xlsx(prefix='oebs_unlinked_employees')
def oebs_unlinked_employees(request):
    """
    Неслинкованные подразделения
    (все подразделения, которые пришли из Оебс
    и по названию которых мы не смогли установить соответствие на Стаффе)
        * название подразделения из Оебс на русском,
        * номер подразделения из Оебс,
        * дата и время последнего получения данных об этом подразделении из Оебс
    """

    return [['oebs_unlinked_employees', UnlinkedEmployees()]]


@permission_required(
    'django_intranet_stuff.can_view_oebs_filred_employees_report',
    raise_exception=True)
@responding_xlsx(prefix='oebs_fired_employees')
def oebs_fired_employees(request):
    """
    Уволенные сотрудники
    (сотрудники, данные о факте увольнения которых расходятся в Стаффе и Оебс,
    учитываются только слинкованные сотрудники)
        * имя и фамилия сотрудника на русском,
        * логин сотрудника (сортировать по возрастанию),
        * гуид сотрудника,
        * дата увольнения на Стаффе,
        * дата увольнения из Оебс,
        * дата и время последнего получения данных об этом сотруднике из Оебс
    """

    return [['oebs_fired_employees', FiredEmployees()]]
